from fastapi import FastAPI, UploadFile, HTTPException
from typing import Dict, Any
import json

app = FastAPI()


def find_and_replace_recursive(data: Any, replacements: Dict[str, str]) -> Any:
    if isinstance(data, dict):
        for key, value in data.items():
            data[key] = find_and_replace_recursive(value, replacements)
    elif isinstance(data, list):
        for i, item in enumerate(data):
            data[i] = find_and_replace_recursive(item, replacements)
    elif isinstance(data, str):
        for old_text, new_text in replacements.items():
            data = data.replace(old_text, new_text)
    return data


@app.post("/replace_values")
async def replace_values(file: UploadFile = UploadFile(...)):
    try:
        content = await file.read()
        json_data = json.loads(content)

        replacements = {
            "Value is Out of Spec": "Out of Spec",
            "Please Enter Recheck Value": "Enter Recheck Value",
            "Please Enter Comment": "Enter Comment",
            "Please Enter Value": "Enter Value",
            "AssociateAssetResource": "OplAssociateAssetResource",
            "w-200px": ""
        }

        updated_json = find_and_replace_recursive(json_data, replacements)

        return updated_json
    except json.JSONDecodeError:
        raise HTTPException(status_code=400, detail="Invalid JSON format in the uploaded file.")
